<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

$widget = $args['this'];

$widget->start_controls_section(
    'progress_temp5_text',
    [
        'label'      => __( 'Progress Text', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);
$widget->add_control(
    'progress_temp5_show_hide',
    [
        'label'         => __( 'Show/Hide Text', 'codesigner' ),
        'type'          => Controls_Manager::SWITCHER,
        'label_on'      => __( 'Show', 'codesigner' ),
        'label_off'     => __( 'Hide', 'codesigner' ),
        'return_value'  => 'yes',
        'default'       => 'yes',
    ]
);

$widget->add_control(
    'progress_temp5_billing_txt',
    [
        'label'         => __( 'Billing Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Billing Info', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp5_show_hide' => 'yes'
        ],
    ]
);

$widget->add_control(
    'progress_temp5_shipping_txt',
    [
        'label'         => __( 'Shipping Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Shipping Info', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp5_show_hide' => 'yes'
        ],
    ]
);

$widget->add_control(
    'progress_temp5_order_inf_txt',
    [
        'label'         => __( 'Order Info Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order Info', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp5_show_hide' => 'yes'
        ],
    ]
);

$widget->add_control(
    'progress_temp5_payment_inf_txt',
    [
        'label'         => __( 'Payment Info Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Payment Info', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp5_show_hide' => 'yes'
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp5_footer_btn-texts',
    [
        'label'      => __( 'Footer Buttons Text', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);

$widget->add_control(
    'back_to_cart_txt_temp5',
    [
        'label'         => __( 'Back To Cart', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Back To Cart', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->add_control(
    'nxt_btn_txt_temp5',
    [
        'label'         => __( 'Next Button', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Continue To Order', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->add_control(
    'prev_btn_txt_temp5',
    [
        'label'         => __( 'Previous Button', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Previous', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp5_order_btn_text',
    [
        'label'      => __( 'Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);
$widget->add_control(
    'order_btn_txt_temp5',
    [
        'label'         => __( 'Order Button', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Place Order', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->end_controls_section();
//style start

$widget->start_controls_section(
    'cd_checkout_temp5_coupon_form_style',
    [
        'label'      => __( 'Coupon Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);

$widget->start_controls_tabs(
    'cd_checkout_temp5_coupon_form_style_tabs'
);

$widget->start_controls_tab(
    'cd_checkout_temp5_coupon_form_message_tab',
    [
        'label' => esc_html__( 'Message', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_coupon_form_message_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-template ul li',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_message_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template ul li' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_temp5_coupon_form_input_tab',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_coupon_form_input_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-template .wl-cf-apply-coupon-fields .input-text',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_input_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template .wl-cf-apply-coupon-fields .input-text' => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-template .wl-cf-apply-coupon-fields .input-text:focus' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_input_placeholder_color',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template .wl-cf-apply-coupon-fields .input-text::placeholder' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_input_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template .wl-cf-apply-coupon-fields .input-text' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' 		=> 'cd_checkout_temp5_coupon_form_input_border',
        'selector' 	=> '{{WRAPPER}} .cd-checkout-template .wl-cf-apply-coupon-fields .input-text, 
                        {{WRAPPER}} .cd-checkout-template .wl-cf-apply-coupon-fields .input-text:focus',
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_temp5_coupon_form_input_box_shadow',
        'selector' 	=> '{{WRAPPER}} .cd-checkout-template .wl-cf-apply-coupon-fields .input-text',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_input_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .cd-checkout-template .wl-cf-apply-coupon-fields .input-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_coupon_form_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '.woocommerce .cd-checkout-template form.checkout_coupon [name=coupon_code]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp5_coupon_from_apply_style',
    [
        'label'      => __( 'Coupon Form Submit', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);

$widget->start_controls_tabs(
    'cd_checkout_temp5_coupon_form_apply_style_tabs'
);

$widget->start_controls_tab(
    'cd_checkout_temp5_coupon_form_normal_tab',
    [
        'label' => esc_html__( 'Normal', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_coupon_form_normal_apply_typography',
        'selector'  => '.cd-checkout-template .checkout_coupon button[type="submit"]',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_normal_apply_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_normal_apply_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' 		=> 'cd_checkout_temp5_coupon_form_normal_apply_border',
        'selector' 	=> '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_normal_apply_border_radius',
    [
        'label' 		=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_temp5_coupon_form_normal_apply_box_shadow',
        'selector' 	=> '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_normal_apply_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_temp5_coupon_form_hover_tab',
    [
        'label' => esc_html__( 'Hover', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_coupon_form_hover_apply_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]:hover',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_hover_apply_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]:hover' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_hover_apply_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]:hover' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' 		=> 'cd_checkout_temp5_coupon_form_hover_apply_border',
        'selector' 	=> '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]:hover',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_hover_apply_border_radius',
    [
        'label' 		=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_temp5_coupon_form_hover_apply_box_shadow',
        'selector' 	=> '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]:hover',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_coupon_form_hover_apply_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .cd-checkout-template .checkout_coupon button[type="submit"]:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp5',
    [
        'label'      => __( 'Checkout Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_temp5_background',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5' => 'background: {{VALUE}} ',
        ],
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_background_padding',
    [
        'type' => Controls_Manager::DIMENSIONS,
        'label' => esc_html__( 'Padding', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp5_progress_form_style',
    [
        'label'      => __( 'Progress Style', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);

$widget->start_controls_tabs(
    'cd_checkout_temp5_progress_form_style_tabs'
);

$widget->start_controls_tab(
    'cd_checkout_temp5_progress_tab',
    [
        'label' => esc_html__( 'Progressbar', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_progress_typography',
        'selector'  =>'{{WRAPPER}} li:not(.complete):not(.active) .cd-step-number, {{WRAPPER}} li:not(.complete):not(.active) .cd-temp-5-bottom'
    ]
);

$widget->add_control(
    'cd_checkout_temp5_progress_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} li:not(.complete) .cd-step-number' => 'color: {{VALUE}}',
            '{{WRAPPER}} li:not(.complete) .cd-temp-5-bottom' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_progress_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-progressbar li:not(.complete) .cd-single-progressbar' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'      => 'cd_checkout_temp5_progress_border',
        'selector'  => '{{WRAPPER}} .cd-progressbar li:not(.complete) .cd-single-progressbar, 
                        {{WRAPPER}} .cd-progressbar li:not(.complete) .cd-single-progressbar:focus',
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name'      => 'cd_checkout_temp5_progress_box_shadow',
        'selector'  => '{{WRAPPER}} li:not(.complete):not(.active) .cd-single-progressbar',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_progress_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} li:not(.complete):not(.active) .cd-single-progressbar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_temp5_progress_tab_active',
    [
        'label' => esc_html__( 'Active', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_progress_typography_active',
        'selector'  => '{{WRAPPER}} li.active .cd-step-number ,{{WRAPPER}} li.active .cd-temp-5-bottom',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_progress_color_active',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-progressbar li.active .cd-step-number' => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-progressbar li.active .cd-temp-5-bottom' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_progress_background_active',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-progressbar li.active .cd-single-progressbar' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_progress_border_bottom',
    [
        'label'     => esc_html__( 'Border Bottom', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-progressbar .active' => 'border-bottom: 5px solid  {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'      => 'cd_checkout_temp5_progress_border_active',
        'selector'  => '{{WRAPPER}} .cd-progressbar li.active .cd-single-progressbar, 
                        {{WRAPPER}} .cd-progressbar li.active .cd-single-progressbar:focus',
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name'      => 'cd_checkout_temp5_progress_box_shadow_active',
        'selector'  => '{{WRAPPER}} .cd-progressbar li.active .cd-single-progressbar',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_progress_radius_active',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .cd-progressbar li.active .cd-single-progressbar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_temp5_progress_tab_complete',
    [
        'label' => esc_html__( 'Completed', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_progress_typography_complete',
        'selector'  => '{{WRAPPER}} li.complete .cd-step-number ,{{WRAPPER}} li.complete .cd-temp-5-bottom',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_progress_color_complete',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-progressbar li.complete .dashicons-yes' => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-progressbar li.complete .cd-temp-5-bottom' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_progress_background_complete',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-progressbar li.complete .cd-single-progressbar' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'      => 'cd_checkout_temp5_progress_border_complete',
        'selector'  => '{{WRAPPER}} .cd-progressbar li.complete .cd-single-progressbar, 
                        {{WRAPPER}} .cd-progressbar li.complete .cd-single-progressbar:focus',
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name'      => 'cd_checkout_temp5_progress_box_shadow_complete',
        'selector'  => '{{WRAPPER}} .cd-progressbar li.complete .cd-single-progressbar',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_progress_radius_complete',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .cd-progressbar li.complete .cd-single-progressbar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();

$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp5_billing_form_style',
    [
        'label'      => __( 'Billing/Shipping Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);
$widget->start_controls_tabs(
    'cd_checkout_temp5_billing_form_design'
);
$widget->start_controls_tab(
    'cd_checkout_temp5_form_message_tab',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'       => 'cd_checkout_temp5_form_message_typography',
        'selector'  => ' {{WRAPPER}} .cd-checkout-template-5 .billing-address .cd-checkout-info-input label,
                         {{WRAPPER}} .cd-checkout-template-5 .shipping-address .cd-checkout-info-input label '     
    ]
);
$widget->add_control(
    'cd_checkout_temp5_form_message_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            ' {{WRAPPER}} .cd-checkout-template-5 .billing-address .cd-checkout-info-input label' => 'color: {{VALUE}};' ,
            ' {{WRAPPER}} .cd-checkout-template-5 .shipping-address .cd-checkout-info-input label' => 'color: {{VALUE}};' ,
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'cd_checkout_temp5_form_input_tab',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_form_input_typography',
        'selector'  => '.codesigner {{WRAPPER}} .cd-checkout-template-5 .billing-address #cd-checkout-info-input-1 input,
        .codesigner {{WRAPPER}} .cd-checkout-template-5 .billing-address #cd-checkout-info-input-1 select,
        .codesigner {{WRAPPER}} .cd-checkout-template-5 .shipping-address #cd-checkout-info-input-1 input,
        .codesigner {{WRAPPER}} .cd-checkout-template-5 .shipping-address #cd-checkout-info-input-1 select'

    ]
);
$widget->add_control(
    'cd_checkout_temp5_form_input_color',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5 .billing-address input '            => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-template-5 .billing-address select '           => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-template-5 .billing-address input input:focus' => 'color: {{VALUE}}',

            '{{WRAPPER}} .cd-checkout-template-5 .shipping-address input '            => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-template-5 .shipping-address select '           => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-template-5 .shipping-address input input:focus' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_temp5_form_input_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .billing-address #cd-checkout-info-input-1 input' => 'background: {{VALUE}};',
            '{{WRAPPER}} .billing-address #cd-checkout-info-input-1 select ' => 'background: {{VALUE}};',
            '{{WRAPPER}} .shipping-address #cd-checkout-info-input-1 input' => 'background: {{VALUE}};',
            '{{WRAPPER}} .shipping-address #cd-checkout-info-input-1 select ' => 'background: {{VALUE}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_temp5_form_input_box_shadow',
        'selector' 	=> '.codesigner {{WRAPPER}} .cd-checkout-template-5 #cd-checkout-info-input-1 input, 
                        .codesigner {{WRAPPER}} .cd-checkout-template-5 #cd-checkout-info-input-1 select' 
    ]
);
$widget->add_responsive_control(
    'cd_checkout_temp5_form_input_padding',
    [
        'type' => Controls_Manager::DIMENSIONS,
        'label' => esc_html__( 'Padding', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-info-input-1 input ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} #cd-checkout-info-input-1 select ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp5_order_details_design',
    [
        'label'      => __( 'Order Details Table', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);

$widget->start_controls_tabs (
    'cd_checkout_temp5_details_order_style_tabs'
);

$widget->start_controls_tab(
    'cd_checkout_temp5_order_details_heading',
    [
        'label' 	=> esc_html__( 'Table Heading', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_table_heading_typography',
        'selector' => '{{WRAPPER}} .cd-checkout-info.order .order-data-title',
    ]
);


$widget->add_control(
    'cd_checkout_temp5_order_details_heading_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-info.order .order-data-title' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_order_details_heading_background',
    [
        'label'     => esc_html__( 'Background Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-info.order .order-data-title' => 'background: {{VALUE}} ',
        ],
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_temp5_order_details_body',
    [
        'label' 	=> esc_html__( 'Table Body', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'cd_checkout_temp5_order_details_body_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-order-data-wrapper .cd-light-color' => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-order-data-wrapper .cd-price-color' => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-order-data-wrapper .woocommerce-checkout-review-order-table' => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-order-data-wrapper .woocommerce-checkout-review-order-table tr th' => 'color: {{VALUE}}',
            '.codesigner {{WRAPPER}} .cd-checkout-template-5 .order-total .woocommerce-Price-amount' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_table_body_image_control',
    [
        'type'  => Controls_Manager::SLIDER,
        'label' => esc_html__( 'Image Sizing', 'codesigner-pro' ),
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'devices'         => [ 'desktop', 'tablet', 'mobile' ],
        'desktop_default' => [
            'size' => 64,
            'unit' => 'px',
        ],
        'tablet_default' => [
            'size' => 48,
            'unit' => 'px',
        ],
        'mobile_default' => [
            'size' => 32,
            'unit' => 'px',
        ],
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5 .cd-order-data-wrapper img' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_temp5_product_image_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Image Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .cd-checkout-template-5 .cd-order-data-wrapper img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp5_payment_section',
    [
        'label'      => __( 'Payment Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);
$widget->start_controls_tabs (
    'cd_checkout_temp5_details_payment_style_tabs'
);

$widget->start_controls_tab(
    'cd_checkout_temp5_payment_details',
    [
        'label' 	=> esc_html__( 'Normal', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_table_payment_section_heading_typography',
        'label' 	=> esc_html__( 'Heading Typography', 'codesigner-pro' ),
        'selector' => '{{WRAPPER}} .cd-checkout-template-5 .wc_payment_methods label',
    ]
);
$widget->add_control(
    'cd_checkout_temp5_payment_section_heading_color',
    [
        'label' 	=> esc_html__( 'Heading Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5 .wc-checkout-payment .wc_payment_method label' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_temp5_payment_section_background',
    [
        'label' 	=> esc_html__( 'Section Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '.codesigner {{WRAPPER}} .cd-checkout-template-5 .wc-checkout-payment .wc_payment_method ' => 'background-color: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_temp5_payment_section_whole_box_border_radius',
    [
        'type' => Controls_Manager::DIMENSIONS,
        'label' => esc_html__( 'Section Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5 .wc-checkout-payment .wc_payment_method ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_payment_section_description_color',
    [
        'label' 	=> esc_html__( 'Description Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5 .wc-checkout-payment .wc_payment_method .payment_box p' => 'color: {{VALUE}} ',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_payment_section_description_bgcolor',
    [
        'label'     => esc_html__( 'Description BG Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5 #payment div.payment_box' => 'background: {{VALUE}} ',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_table_payment_section_description_typography',
        'selector' => '{{WRAPPER}} .cd-checkout-template-5 .wc-checkout-payment .wc_payment_method .payment_box p',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_payment_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .cd-checkout-template-5 #payment div.payment_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_temp5_payment_details_hover',
    [
        'label' 	=> esc_html__( 'Active', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_table_payment_section_heading_typography_active',
        'label' 	=> esc_html__( 'Heading Typography', 'codesigner-pro' ),
        'selector' => '{{WRAPPER}} .cd-checkout-template-5 .wc_payment_methods .cd-select label',
    ]
);
$widget->add_control(
    'cd_checkout_temp5_payment_section_heading_color_active',
    [
        'label' 	=> esc_html__( 'Heading Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5 .wc-checkout-payment .wc_payment_method.cd-select label' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_temp5_payment_section_background_active',
    [
        'label' 	=> esc_html__( 'Section Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '.codesigner.woocommerce-checkout  {{WRAPPER}} .cd-checkout-template-5 .wc-checkout-payment #payment .cd-select ' => 'background-color: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_temp5_payment_section_whole_box_border_radius_active',
    [
        'type' => Controls_Manager::DIMENSIONS,
        'label' => esc_html__( 'Section Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5 .wc-checkout-payment .wc_payment_method.cd-select ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_payment_section_description_color_active',
    [
        'label' 	=> esc_html__( 'Description Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5 .wc-checkout-payment .wc_payment_method.cd-select .payment_box p' => 'color: {{VALUE}} ',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_payment_section_description_bgcolor_active',
    [
        'label'     => esc_html__( 'Description BG Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-template-5 #payment .cd-select .payment_box' => 'background: {{VALUE}} ',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_table_payment_section_description_typography_active',
        'selector' => '{{WRAPPER}} .cd-checkout-template-5 .wc-checkout-payment .wc_payment_method.cd-select .payment_box p',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_payment_border_radius_active',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .cd-checkout-template-5 #payment .cd-select .payment_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp5_Order_button',
    [
        'label'      => __( 'Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_order_button_background_typography',
        'selector' => '{{WRAPPER}} .wc-checkout-payment .form-row button#place_order',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_order_button_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .wc-checkout-payment .form-row button#place_order' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_order_button_background',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .wc-checkout-payment .form-row button#place_order' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'      => 'cd_checkout_temp5_order_button_border',
        'selector'  => '{{WRAPPER}} .wc-checkout-payment .form-row button#place_order, 
                        {{WRAPPER}} .wc-checkout-payment .form-row button#place_order:focus',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_order_button_border_radius',
    [
        'type' => Controls_Manager::DIMENSIONS,
        'label' => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} button#place_order' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_temp5_order_button_box_shadow',
        'selector' 	=> '{{WRAPPER}} .wc-checkout-payment .form-row button#place_order',
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp5_footer_button',
    [
        'label'      => __( 'Footer Buttons', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-5',
        ],
    ]
);

$widget->add_control(
    'back_to_cart_show_hide_temp5',
    [
        'label'         => __( 'Show/Hide Text', 'codesigner' ),
        'type'          => Controls_Manager::SWITCHER,
        'label_on'      => __( 'Show', 'codesigner' ),
        'label_off'     => __( 'Hide', 'codesigner' ),
        'return_value'  => 'yes',
        'default'       => 'yes',
    ]
);

$widget->start_controls_tabs(
    'cd_checkout_temp5_btn_separator',
    [
        'separator' => 'before',
        'condition'     => [
            'back_to_cart_show_hide_temp5' => 'yes'
        ],
    ]
);

$widget->start_controls_tab(
    'cd_checkout_temp5_back_to_cart',
    [
        'label'     => __( 'Back To Cart', 'codesigner' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_back_to_cart_typo',
        'selector'  => '{{WRAPPER}} .cd-footer .cd-back-to-cart a',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_back_to_cart_color',
    [
        'label'     => __( 'Color', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-back-to-cart a' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_back_to_cart_bg',
    [
        'label'     => __( 'Background', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-back-to-cart a' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_back_to_cart_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .cd-footer .cd-back-to-cart a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'          => 'cd_checkout_temp5_back_to_cart_border',
        'label'         => __( 'Border', 'codesigner' ),
        'selector'      => '{{WRAPPER}} .cd-footer .cd-back-to-cart a',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_back_to_cart_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '.cd-footer .cd-back-to-cart a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_back_to_cart_hover_color',
    [
        'label'     => __( 'Hover Color', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-back-to-cart a:hover' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_back_to_cart_hover_bg',
    [
        'label'     => __( 'Hover Background', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-back-to-cart a:hover' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'          => 'cd_checkout_temp5_back_to_cart_hover_border',
        'label'         => __( 'Hover Border', 'codesigner' ),
        'selector'      => '{{WRAPPER}} .cd-footer .cd-back-to-cart a:hover',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_back_to_cart_hover_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Hover Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '.cd-footer .cd-back-to-cart a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_temp5_nxt_btn',
    [
        'label'     => __( 'Next', 'codesigner' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_nxt_btn_typo',
        'selector'  => '{{WRAPPER}} .cd-footer .cd-back-to-next button',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_nxt_btn_color',
    [
        'label'     => __( 'Color', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-back-to-next button' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_nxt_btn_bg',
    [
        'label'     => __( 'Background', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-back-to-next button' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_nxt_btn_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .cd-footer .cd-back-to-next button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'          => 'cd_checkout_temp5_nxt_btn_border',
        'label'         => __( 'Border', 'codesigner' ),
        'selector'      => '{{WRAPPER}} .cd-footer .cd-back-to-next button',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_nxt_btn_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '.cd-footer .cd-back-to-next button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_nxt_btn_hover_color',
    [
        'label'     => __( 'Hover Color', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-back-to-next button:hover' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_nxt_btn_hover_bg',
    [
        'label'     => __( 'Hover Background', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-back-to-next button:hover' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'          => 'cd_checkout_temp5_nxt_btn_hover_border',
        'label'         => __( 'Hover Border', 'codesigner' ),
        'selector'      => '{{WRAPPER}} .cd-footer .cd-back-to-next button:hover',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_nxt_btn_hover_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Hover Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '.cd-footer .cd-back-to-next button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();


$widget->start_controls_tab(
    'cd_checkout_temp5_prev_btn',
    [
        'label'     => __( 'Previous', 'codesigner' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_temp5_prev_btn_typo',
        'selector'  => '{{WRAPPER}} .cd-footer .cd-previous button',
    ]
);

$widget->add_control(
    'cd_checkout_temp5_prev_btn_color',
    [
        'label'     => __( 'Color', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-previous button' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_prev_btn_bg',
    [
        'label'     => __( 'Background', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-previous button' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_prev_btn_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .cd-footer .cd-previous button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'          => 'cd_checkout_temp5_prev_btn_border',
        'label'         => __( 'Border', 'codesigner' ),
        'selector'      => '{{WRAPPER}} .cd-footer .cd-previous button',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_nxt_prev_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '.cd-footer .cd-previous button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_prev_btn_hover_color',
    [
        'label'     => __( 'Hover Color', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-previous button:hover' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_temp5_prev_btn_hover_bg',
    [
        'label'     => __( 'Hover Background', 'codesigner' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-footer .cd-previous button:hover' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'          => 'cd_checkout_temp5_prev_btn_hover_border',
        'label'         => __( 'Hover Border', 'codesigner' ),
        'selector'      => '{{WRAPPER}} .cd-footer .cd-previous button:hover',
    ]
);

$widget->add_responsive_control(
    'cd_checkout_temp5_prev_btn_hover_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Hover Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '.cd-footer .cd-previous button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();